import { Text } from "react-native";
import React from "react";
import { groupProductStyle } from "./groupProduct.style";
import usePreferences from "../../../../../../../hooks/usePreferences";
import useLangTranslation from "../../../../../../../hooks/useLangTranslation";

const IndividualItemStock = ({ stockManage }) => {
    const { trans } = useLangTranslation();
    const {
        product_inventory: {
            manage_stock: preferenceManageStock,
            stock_display_format,
        } = {},
    } = usePreferences();
    const {
        manage_stocks,
        total_stocks,
        stock_status,
        critical_stock_quantity: criticalStockQuantity,
        stock_hide,
        backorders
    } = stockManage;
    return (
        <>
            {(preferenceManageStock == "0" ||
                (preferenceManageStock == "1" && manage_stocks == "0")) && (
                <Text style={groupProductStyle.stock}>
                    {stock_status?.toLowerCase() == "out of stock"
                        ? trans("Out Of Stock")
                        : trans("In Stock")}
                </Text>
            )}
            {preferenceManageStock == "1" &&
                manage_stocks == "1" &&
                stock_hide != 1 && (
                    <>
                    {
                        backorders == 1 ? <>
                        <Text style={groupProductStyle.stock}>{trans("In Stock")}</Text>
                        </> : <>
                        {total_stocks <= 0 &&
                            stock_status &&
                            stock_display_format == "always_show" && (
                                <Text style={groupProductStyle.stock}>
                                    {total_stocks <= 0
                                        ? trans("Out Of Stock")
                                        : trans("In Stock")}
                                </Text>
                            )}
                        {total_stocks > 0 &&
                            stock_display_format == "always_show" && (
                                <Text style={groupProductStyle.stock}>
                                    {trans("{{x}} Items Remaining", {
                                        x: total_stocks,
                                    })}
                                </Text>
                            )}
                        {total_stocks > 0 &&
                            total_stocks < criticalStockQuantity &&
                            stock_display_format == "sometime_show" && (
                                <Text style={groupProductStyle.stock}>
                                    {trans("Only {{x}} left in stock.", {
                                        x: total_stocks,
                                    })}
                                </Text>
                            )}
                        </>
                    }
                       
                    </>
                )}
        </>
    );
};

export default IndividualItemStock;
